#ifndef	UNICODE
#define	UNICODE
#endif	/* UNICODE */
#ifndef	_UNICODE
#define	_UNICODE
#endif	/* _UNICODE */
#define	STRICT
#include <windows.h>
#include <commctrl.h> 
#include	<commdlg.h>
#include <wingdi.h>
#include "resource.h" 
#include <Winbase.h>
#include "kaede.h"
 
BYTE get_pixel(BYTE *buf,int x,int y)
{
	static BYTE shift[8]={6,4,2,0};
	return (buf[((300-y)*240+x)/4]>>shift[x%4])&3; 
}

void set_pixel(BYTE *buf,int x,int y,BYTE c)
{
	static BYTE and_mask[4]={0x3f,0xcf,0xf3,0xfc};
	static BYTE shift[4]={6,4,2,0};
	if (c>=4) return;
	if (x<0 || 240<=x || y<0 || 300<=y) return;
	int k=((300-1-y)*240+x)/4;
	buf[k]&=and_mask[x%4];
	buf[k]|=c<<shift[x%4];
}

void put_face(HWND hWnd,int face,int hand)
{
	static TCHAR *face_pic[7]={
		TEXT("head1.bmp"),
		TEXT("head1.bmp"),
		TEXT("head2.bmp"),
		TEXT("head3.bmp"),
		TEXT("head4.bmp"),
		TEXT("head5.bmp"),
		TEXT("head6.bmp"),
	};

	if (face==-1) {
		extern int head_num;
		face=head_num;
	}
	if (hand==-1) {
		extern int hand_num;
		hand=hand_num;
	}

	if (face>6) face=6;
	if (hand>2) hand=1;

	load_picture(TEXT("body.bmp"),hWnd,0,0,TRUE);
	if (face>0)
		load_picture(face_pic[face],hWnd,112,0,TRUE);
	if (hand>0)
		load_picture(TEXT("hand.bmp"),hWnd,20,178,TRUE);
}

void put_moji(HWND hWnd,TCHAR *fn,int my,int sw)
{
	int	dx,dy;
	int	px,py;
	int	margin;
	int	sx,sy,ex,ey;
	int i,j;

	load_picture_size(fn,&dx,&dy);
	if (dy<10) dy=10;
	if (my<150) {
		py=my+(dy*2+sw*30);
	} else {
		py=my-(dy*2+sw*30);
	}
	px=120-(dx/2);
	margin=3+sw*3;
	sx=px-margin;
	sy=py-margin;
	ex=px+dx+margin;
	ey=py+dy+margin;

	for (j=sy-2;j<=ey+2;j++)
		for (i=sx-2;i<=ex+2;i++)
			set_pixel(baseBuf,i,j,3);
	if (sw==0) {
		for (j=sy;j<=ey;j++) {
			set_pixel(baseBuf,sx,j,0);
			set_pixel(baseBuf,ex,j,0);
		}
		for (i=sx;i<=ex;i++) {
			set_pixel(baseBuf,i,sy,0);
			set_pixel(baseBuf,i,ey,0);
		}
	} else {
		for (j=sy-1;j<=ey+1;j++)
			for (i=sx-1;i<=ex+1;i++)
				if ((j<=sy+1 || ey-1<=j) || (i<=sx+1 || ex-1<=i))
					set_pixel(baseBuf,i,j,0);
	}
	load_picture(fn,hWnd,px,py,FALSE);
}
