#ifndef	UNICODE
#define	UNICODE
#endif	/* UNICODE */
#ifndef	_UNICODE
#define	_UNICODE
#endif	/* _UNICODE */
#define	STRICT
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include	<commdlg.h>
#include <wingdi.h> 
#include <Winuser.h>
#include "resource.h" 
#include <Winbase.h>
#include "jzpaint.h"
DWORD	gle=0;

/* =====================================================================
	֐̃vg^Cv錾
===================================================================== */
// WinMainĂ΂֐
BOOL InitApplication(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);

// R[obN֐
LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);

// _CAO֐
BOOL CALLBACK AboutDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK PropertyDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK TreeDlgProc(HWND, UINT, WPARAM, LPARAM);

// bZ[W֐
void OnCreate(HWND, WPARAM, LPARAM);
void OnDestroy(HWND, WPARAM, LPARAM);
void OnPaint(HWND, WPARAM, LPARAM);
void OnHelp(HWND, WPARAM, LPARAM);
void mouse_down(HWND,WPARAM, LPARAM);
void mouse_move(HWND,WPARAM, LPARAM);
void mouse_up(HWND,WPARAM, LPARAM);
BOOL load_bmp(HWND);
//void put_property(HWND);
void put_tree(HWND);
BOOL set_reg(void);
BOOL get_reg(void);

TCHAR		Message[ 256 ] ;

int	cbh;
int	bitspixel;

int	disp_x=20,disp_y=20;
int	tap_x,tap_y;

BOOL	pesi_flag;

// t@CEj[֐
void OnFileExit(HWND);			// I

// wvEj[֐
void OnHelpAbout(HWND);			// o[W

/* =====================================================================
	O[oϐ
===================================================================== */
TCHAR gszAppName[]	= TEXT("JZKiss");	// NX̖O
TCHAR gszAppTitle[]	= TEXT("JZKiss");	// EBhEE^Cg

HINSTANCE ghInst	= NULL;		// ݂̃CX^X
HWND      ghWnd		= NULL;		// CEBhẼnh
HWND      ghWndCB	= NULL;		// R}ho[̃nh
HACCEL	  hAccel    = NULL;

HDC		baseDC	= NULL;		// ItXN[
HBITMAP	baseBmp	= NULL;
BYTE *baseBuf;
HDC		bgDC	= NULL;		// ItXN[
HBITMAP	bgBmp	= NULL;
BYTE *bgBuf;

int	winWidth,winHeight;
BOOL	pspc_flag;

COLORREF col[4];

TCHAR	listbox_filename[1024][MAX_PATH];
int		listbox_num,listbox_max;

BOOL	esc_flag=TRUE;

BOOL	under_dir_flag=FALSE;

#define	TOP_TREE_STR	TEXT("\\ (Top)")

#define		subkey	TEXT("Software\\JINZO\\JINZO_Viewr")
TCHAR		reg_dir[MAX_PATH],reg_file[MAX_PATH];
int			reg_sortkey;
int			reg_recursive;



//--------------------------------------------------------
CNF		cnf;
CELL	cell[MAX_CELL];
PAL		pal[MAX_PAL_FILE];
OBJ		object[MAX_OBJ];

int		tap_obj;
int		tap_obj_x,tap_obj_y;
int		tap_obj_x2,tap_obj_y2;

int		current_set=0;

BOOL	overview_flag=TRUE;
int		ov_sx,ov_sy,ov_xs,ov_ys;

BOOL	unload_flag=TRUE;
BOOL	clear_flag=FALSE;

extern BOOL load_cnf(TCHAR *,TCHAR *);

/* =====================================================================
	WindowsvÕC֐
===================================================================== */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
					 LPTSTR lpszCmdParm, int nCmdShow)
{
	MSG    msg;

    // EBhĚ
    HWND hWnd = FindWindow(gszAppName, gszAppTitle);
    if (hWnd) {
        // ɋNĂEBhEőOʂɈړďI
        SetForegroundWindow(hWnd);
        return 0;
    }

	ghInst = hInstance;

	if (!hPrevInstance) {					// ق̃CX^Xs ?
		if (!InitApplication(hInstance))	// ʂ̏
			return FALSE;					// Ɏsꍇ͏I
	}
	if (!InitInstance(hInstance, nCmdShow))	// CX^X̏
		return FALSE;						// sꍇ͏I

	hAccel=LoadAccelerators(ghInst,MAKEINTRESOURCE(IDR_ACCEL));
	while (GetMessage(&msg, NULL, 0, 0)) {	// bZ[W̎擾ƃfBXpb`
		if (!TranslateAccelerator(msg.hwnd,hAccel,&msg)) {
			TranslateMessage(&msg);				// zL[R[h̕ϊ
			DispatchMessage(&msg);				// bZ[W̃fBXpb`
		}
	}
	return msg.wParam;		// PostQuitMessage()֐̖߂lԂ
}

/* =====================================================================
	EBhEENX̓o^
===================================================================== */
BOOL InitApplication(HINSTANCE hInstance)
{
	WNDCLASS wc;

	wc.style		 = 0;					// NXEX^C
	wc.lpfnWndProc	 = MainWndProc;			// EBhEEvV[W
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;			// CX^XEnh
	wc.hIcon		 = NULL;
	wc.hCursor		 = NULL;
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName	 = NULL;				// j[̖O
	wc.lpszClassName = gszAppName;			// EBhEENX̖O

	return RegisterClass(&wc);	// EBhEENX̓o^
}

/* =====================================================================
	EBhE̍쐬ƕ\
===================================================================== */
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	ghWnd = CreateWindow( 
 		gszAppName,				// o^ꂽEBhEENX̖O
		gszAppTitle,			// ^CgEo[ɕ\eLXg
		WS_VISIBLE,				// EBhEEX^C
		CW_USEDEFAULT,			// EBhE̕\ʒu ()
		CW_USEDEFAULT,			//                      ()
		CW_USEDEFAULT,			// EBhȆ傫   ()
		CW_USEDEFAULT,			//                      ()
		NULL,					// eEBhẼnh
		NULL,					// EBhEENX̃j[gp
		hInstance,				// AvP[VECX^X̃nh
		NULL					// EBhE쐬f[^̃AhX
	);
	if (!ghWnd)
		return FALSE;			// EBhE̍쐬Ɏs

	ShowWindow(ghWnd, nCmdShow);	// EBhE\Ԃ̐ݒ
	UpdateWindow(ghWnd);			// NCAg̈̍XV

	return TRUE;
}

/* =====================================================================
	EBhEEvV[W
===================================================================== */
void make_command_bar(HWND hWnd)
{
}
void menu_check(void)
{
}

void jzp_timer(HWND hWnd)
{
}

LRESULT CALLBACK MainWndProc(HWND hWnd, UINT uMessage,
						 WPARAM wParam, LPARAM lParam)
{
	int	old_set;
	switch (uMessage) {
		case WM_CREATE:		OnCreate(hWnd, wParam, lParam);		break;
		case WM_DESTROY:	OnDestroy(hWnd, wParam, lParam);	break;
		case WM_PAINT:		OnPaint(hWnd, wParam, lParam);		break; 
		case WM_HELP:		OnHelp(hWnd, wParam, lParam);		break;

		case WM_COMMAND: 
			switch (LOWORD(wParam)) {
			// t@CEj[
				case IDM_EXIT:		OnFileExit(hWnd);		break;

			// wvEj[
				case IDM_ABOUT:		OnHelp(hWnd, wParam, lParam);		break;
/*
				case IDM_PROPERTY:
					put_property(hWnd);
					break;
*/
				case IDM_TREE:
					put_tree(hWnd);
					break;

				case IDM_VIEW:
					overview_flag=(overview_flag==TRUE) ? FALSE : TRUE;
					clear_flag=TRUE;
					InvalidateRect(hWnd,NULL,FALSE);
					break;

				case IDM_SET_0:
					old_set=current_set;
					current_set=0;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_1:
					old_set=current_set;
					current_set=1;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_2:
					old_set=current_set;
					current_set=2;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_3:
					old_set=current_set;
					current_set=3;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_4:
					old_set=current_set;
					current_set=4;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_5:
					old_set=current_set;
					current_set=5;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_6:
					old_set=current_set;
					current_set=6;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_7:
					old_set=current_set;
					current_set=7;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_8:
					old_set=current_set;
					current_set=8;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;
				case IDM_SET_9:
					old_set=current_set;
					current_set=9;
					change_set(current_set,old_set);
					calc_all(current_set);
					InvalidateRect(hWnd,NULL,FALSE);
					break;

				case IDM_BG_ORIGINAL:
					if (bitspixel==2) {
						bg_num=4;
						calc_all(current_set);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case IDM_BG_BLACK:
					if (bitspixel==2) {
						bg_num=0;
						calc_all(current_set);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case IDM_BG_DGRAY:
					if (bitspixel==2) {
						bg_num=1;
						calc_all(current_set);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case IDM_BG_LGRAY:
					if (bitspixel==2) {
						bg_num=2;
						calc_all(current_set);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case IDM_BG_WHITE:
					if (bitspixel==2) {
						bg_num=3;
						calc_all(current_set);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;

			default:
				return DefWindowProc(hWnd, uMessage, wParam, lParam);
			}
		case WM_INITMENUPOPUP:
			{
				BOOL	mode;
				UINT	set_menu[MAX_SET]={
					IDM_SET_0,IDM_SET_1,IDM_SET_2,IDM_SET_3,IDM_SET_4,
					IDM_SET_5,IDM_SET_6,IDM_SET_7,IDM_SET_8,IDM_SET_9};
				int		i;

				HMENU hMenu = CommandBar_GetMenu( GetDlgItem(hWnd,1), 0 );
				mode= (overview_flag==TRUE) ? MF_CHECKED : MF_UNCHECKED;
				CheckMenuItem(hMenu,IDM_VIEW,	MF_BYCOMMAND | mode);

				for (i=0;i<MAX_SET;i++) {
					mode= (current_set==i) ? MF_CHECKED : MF_UNCHECKED;
					CheckMenuItem(hMenu,set_menu[i],MF_BYCOMMAND | mode);
				}

				if (bitspixel!=2) {
					EnableMenuItem(hMenu,IDM_BG_BLACK,	MF_GRAYED);
					EnableMenuItem(hMenu,IDM_BG_DGRAY,	MF_GRAYED);
					EnableMenuItem(hMenu,IDM_BG_LGRAY,	MF_GRAYED);
					EnableMenuItem(hMenu,IDM_BG_WHITE,	MF_GRAYED);
				}

				mode= (bg_num==4) ? MF_CHECKED : MF_UNCHECKED;
				CheckMenuItem(hMenu,IDM_BG_ORIGINAL,	MF_BYCOMMAND | mode);
				mode= (bg_num==0) ? MF_CHECKED : MF_UNCHECKED;
				CheckMenuItem(hMenu,IDM_BG_BLACK,	MF_BYCOMMAND | mode);
				mode= (bg_num==1) ? MF_CHECKED : MF_UNCHECKED;
				CheckMenuItem(hMenu,IDM_BG_DGRAY,	MF_BYCOMMAND | mode);
				mode= (bg_num==2) ? MF_CHECKED : MF_UNCHECKED;
				CheckMenuItem(hMenu,IDM_BG_LGRAY,	MF_BYCOMMAND | mode);
				mode= (bg_num==3) ? MF_CHECKED : MF_UNCHECKED;
				CheckMenuItem(hMenu,IDM_BG_WHITE,	MF_BYCOMMAND | mode);
				
			}
		case WM_KEYDOWN:
			switch (LOWORD(wParam)) {
				case VK_UP:
					if (overview_flag!=TRUE) {
						disp_y-=winHeight/16;
						if (disp_y<0) disp_y=0;
						calc_area(current_set,disp_x,disp_y,winWidth,winHeight);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case VK_LEFT:
					if (overview_flag!=TRUE) {
						disp_x-=winWidth/16;
						if (disp_x<0) disp_x=0;
						calc_area(current_set,disp_x,disp_y,winWidth,winHeight);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case VK_DOWN:
					if (overview_flag!=TRUE) {
						disp_y+=winHeight/16;
						if (disp_y>=cnf.height-winHeight-CommandBar_Height(ghWndCB)+cbh) disp_y=cnf.height-winHeight-CommandBar_Height(ghWndCB)+cbh;
						calc_area(current_set,disp_x,disp_y,winWidth,winHeight);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
				case VK_RIGHT:
					if (overview_flag!=TRUE) {
						disp_x+=winWidth/16;
						if (disp_x>=cnf.width-winWidth) disp_x=cnf.width-winWidth;
						calc_area(current_set,disp_x,disp_y,winWidth,winHeight);
						InvalidateRect(hWnd,NULL,FALSE);
					}
					break;
/*
				case VK_ESCAPE:
					if (esc_flag==TRUE) {
						cbh=0;
						esc_flag=FALSE;
					} else {
						cbh=CommandBar_Height(ghWndCB);
						esc_flag=TRUE;
					}
//					ShowWindow(FindWindow(TEXT("HHTaskBar"),TEXT("")),esc_flag ? SW_SHOW : SW_HIDE),
					CommandBar_Show(ghWndCB,esc_flag);
					if (disp_y>=cnf.height-winHeight-CommandBar_Height(ghWndCB)+cbh) disp_y=cnf.height-winHeight-CommandBar_Height(ghWndCB)+cbh;
					InvalidateRect(hWnd,NULL,FALSE);
					break;
*/
				default:
					return DefWindowProc(hWnd, uMessage, wParam, lParam);
			}
		case WM_LBUTTONDOWN:	mouse_down(hWnd,wParam, lParam);	break;
		case WM_MOUSEMOVE:		mouse_move(hWnd,wParam, lParam);	break;
		case WM_LBUTTONUP:		mouse_up(hWnd,wParam, lParam);		break;
		default:
			return DefWindowProc(hWnd, uMessage, wParam, lParam);
	} 

	return 0;
}

/* =====================================================================
	EBhE쐬̏
===================================================================== */
void OnCreate(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	HDC	hDC;
	RECT rc;
	// R}ho[̐
//	InitCommonControls();
	ghWndCB = CommandBar_Create(ghInst, hWnd, 1);

	// ʂ̃TCY擾
	cbh=CommandBar_Height(ghWndCB);
	GetWindowRect(hWnd, &rc);
	winWidth  = rc.right - rc.left;
	winHeight = rc.bottom - rc.top - cbh;
	if (winWidth<=240)	pspc_flag=TRUE;
	else				pspc_flag=FALSE;
	
	if (pspc_flag==TRUE) {
		CommandBar_InsertMenubar(ghWndCB, ghInst, IDR_MAIN_MENU, 0);
		CommandBar_AddAdornments(ghWndCB, CMDBAR_HELP, 0);
	} else {
		CommandBar_InsertMenubar(ghWndCB, ghInst, IDR_MAIN_H_MENU, 0);
		CommandBar_AddAdornments(ghWndCB, CMDBAR_HELP, 0);
	}

	menu_check();

	// ACR̐ݒ
	HICON hIcon = (HICON)LoadImage(ghInst, MAKEINTRESOURCE(IDI_MAIN_ICON),
		IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	SendMessage(hWnd, WM_SETICON, FALSE, (WPARAM)hIcon);

	bitspixel=GetDeviceCaps(GetDC(NULL),BITSPIXEL);
	if (bitspixel==16) bitspixel=24;


	// ItXN[̍쐬
//	bmi.bmih.biWidth = winWidth;
//	bmi.bmih.biHeight = winHeight ;
	bmi.bmih.biWidth = MAX_WIDTH;
	bmi.bmih.biHeight = MAX_HEIGHT ;
	bmi.bmih.biSize = sizeof(bmi.bmih) ;
	bmi.bmih.biPlanes = 1 ;
	bmi.bmih.biBitCount = bitspixel; 
	bmi.bmih.biCompression = BI_RGB ;
	bmi.bmih.biSizeImage = 0 ;
	bmi.bmih.biXPelsPerMeter = 0 ; 
	bmi.bmih.biYPelsPerMeter = 0 ;
	bmi.bmih.biClrUsed = 0 ;
	bmi.bmih.biClrImportant = 0 ;
	if (bitspixel==2) {
		bmi.rgq[0].rgbBlue = bmi.rgq[0].rgbGreen = bmi.rgq[0].rgbRed = 0 ;
		bmi.rgq[1].rgbBlue = bmi.rgq[1].rgbGreen = bmi.rgq[1].rgbRed = 132 ;
		bmi.rgq[2].rgbBlue = bmi.rgq[2].rgbGreen = bmi.rgq[2].rgbRed = 198 ;
		bmi.rgq[3].rgbBlue = bmi.rgq[3].rgbGreen = bmi.rgq[3].rgbRed = 255 ;
	}
	
	hDC = GetDC(NULL);
	baseBmp = CreateDIBSection( hDC, (PBITMAPINFO)&bmi.bmih, DIB_RGB_COLORS,
							 (void **)&baseBuf, NULL, 0 ) ;
	if ( !baseBmp ) {
		wsprintf( Message, TEXT("baseBmp error (%d)"),GetLastError() ) ;
		MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
		ReleaseDC( NULL, hDC ) ;
		MessageBeep( MB_ICONASTERISK ) ;
		return  ;
	}
	baseDC = CreateCompatibleDC( hDC ) ;
	if ( !baseDC ) {
		wsprintf( Message, TEXT("baseDC error (%d)"),GetLastError() ) ;
		MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
		DeleteObject( baseBmp);
		ReleaseDC( NULL, hDC ) ;
		MessageBeep( MB_ICONASTERISK ) ;
		return  ;
	}
	SelectObject( baseDC, baseBmp ) ; 

	if (bitspixel==2) {
		bgBmp = CreateDIBSection( hDC, (PBITMAPINFO)&bmi.bmih, DIB_RGB_COLORS,
								 (void **)&bgBuf, NULL, 0 ) ;
		if ( !bgBmp ) {
			wsprintf( Message, TEXT("bgBmp error (%d)"),GetLastError() ) ;
			MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
			DeleteObject( baseBmp);
			ReleaseDC( NULL, baseDC ) ;
			ReleaseDC( NULL, hDC ) ;
			MessageBeep( MB_ICONASTERISK ) ;
			return  ;
		}
		bgDC = CreateCompatibleDC( hDC ) ;
		if ( !bgDC ) {
			wsprintf( Message, TEXT("bgDC error (%d)"),GetLastError() ) ;
			MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
			DeleteObject( baseBmp);
			ReleaseDC( NULL, baseDC ) ;
			MessageBeep( MB_ICONASTERISK ) ;
			return  ;
		}
		SelectObject( bgDC, bgBmp ) ; 
	}

	put_tree(hWnd);
/*
	if (bitspixel==2) {
		col[0]=RGB(0,0,0);
		col[1]=RGB(0x84,0x84,0x84);
		col[2]=RGB(0xc6,0xc6,0xc6);
		col[3]=RGB(0xff,0xff,0xff);
	} 
	 
//	SetTimer(hWnd, 1000,100,NULL); 

	if (get_reg()==TRUE) {
		int		i;
		sortkey=reg_sortkey;
		under_dir_flag= reg_recursive==0 ? FALSE : TRUE;
		get_file_info(hWnd,reg_dir,FALSE);
		for (i=0;i<bmp_file_max;i++) {
			if (wcscmp(bmpfile[sort_result[sortkey][i]],reg_file)==0) {
				disp_x=disp_y=0;
				bmp_num=i;
				load_core(hWnd,bmpfile[sort_result[sortkey][bmp_num]]);
				SendMessage(hCommandCombo, CB_SETCURSEL, bmp_num, 0);
				break;
			}
		}
	} else {
		sortkey=KEY_CDATE;
		get_file_info(hWnd,TEXT("\\"),FALSE);
		load_core(hWnd,bmpfile[sort_result[sortkey][bmp_num]]);
	}
*/
	disp_x=0;
	disp_y=0;
}

/* =====================================================================
	EBhEj̏
===================================================================== */

void OnDestroy(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	// R}ho[̔j
	CommandBar_Destroy(ghWndCB);
	PostQuitMessage(0); 
} 

/* =====================================================================
	ʂ̕`
===================================================================== */ 
void OnPaint(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC         hDC;
	int			i,j;

	SetFocus(hWnd);
	hDC = BeginPaint(hWnd, &ps);

//	calc_all(z);
//	z++;
//	if (z>=set_max) z=0;
	if (unload_flag!=TRUE) {
		if (clear_flag==TRUE) {
			for (j=0;j<cnf.height;j++)
				for (i=0;i<cnf.width;i++)
					set_pixel(baseBuf,i,j,bitspixel==2 ? gray_background : 0xffffff);
			BitBlt(hDC, 0,cbh,winWidth, winHeight+cbh, baseDC, 0,0, SRCCOPY);
			calc_all(current_set);
			clear_flag=FALSE;
		}
		if (overview_flag==TRUE) {
			StretchBlt(hDC, ov_sx,ov_sy+cbh,ov_xs, ov_ys, baseDC, 0,0,cnf.width-1,cnf.height-1, SRCCOPY);
		} else {
			BitBlt(hDC, 0,cbh,winWidth, winHeight+cbh, baseDC, disp_x,disp_y, SRCCOPY);
		}
	}
	EndPaint(hWnd, &ps);
}
void mouse_down(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	if (unload_flag==TRUE) return;

	tap_x = LOWORD(lParam);
	tap_y = HIWORD(lParam)-cbh;

	if (overview_flag==TRUE) {
		tap_obj=-1;
		tap_x=(tap_x-ov_sx)*cnf.width/ov_xs;
		tap_y=(tap_y-ov_sy)*cnf.height/(ov_ys);
		if (tap_x<0 || cnf.width<=tap_x) return;
		if (tap_y<0 || cnf.height<=tap_y) return;
	}

	tap_obj=detect_pos(current_set,tap_x,tap_y,disp_x,disp_y);
	if (tap_obj>=0) {
		tap_obj_x=object[cell[tap_obj].mark].x[current_set];
		tap_obj_y=object[cell[tap_obj].mark].y[current_set];
	}
	tap_obj_x2=object[cell[tap_obj].mark].x[current_set];
	tap_obj_y2=object[cell[tap_obj].mark].y[current_set];
	pesi_flag=FALSE;
}

void mouse_move(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	int	x,y,dx,dy,i;
	RECT	rc;

	if (unload_flag==TRUE) return;
	if (pesi_flag==TRUE) return;

	x = LOWORD(lParam);
	y = HIWORD(lParam)-cbh;

	if (overview_flag==TRUE) {
		x=(x-ov_sx)*cnf.width/ov_xs;
		y=(y-ov_sy)*cnf.height/(ov_ys);
		if (x<0 || cnf.width<=x) return;
		if (y<0 || cnf.height<=y) return;
	}

	if (tap_obj>=0) {
		dx=x-tap_x;
		dy=y-tap_y;
		
		if (object[cell[tap_obj].mark].fix>0) {
			if (pesi_flag==FALSE) {
				int		f;
				f=object[cell[tap_obj].mark].ini_fix;
				if (f>64)	f=64;
				f=(f-object[cell[tap_obj].mark].fix)/4;
				if (f<0) f=0;
				if (dx<-f || f<dx || dy<0 || f<dy) {
					dx=0;
					dy=0;
					pesi_flag=TRUE;
				}
			}
		}

		for (i=0;i<cell_max;i++) {
			if (cell[i].mark!=cell[tap_obj].mark) continue;
			if (cell[i].set[current_set]!=TRUE) continue;
			if (tap_obj_x+dx+cell[i].x_offset<0) dx=-tap_obj_x-cell[i].x_offset;
			if (tap_obj_y+dy+cell[i].y_offset<0) dy=-tap_obj_y-cell[i].y_offset;
			if (tap_obj_x+dx+cell[i].x_offset+cell[i].width >=cnf.width )	dx=cnf.width -tap_obj_x-cell[i].x_offset-cell[i].width;
			if (tap_obj_y+dy+cell[i].y_offset+cell[i].height>=cnf.height)	dy=cnf.height-tap_obj_y-cell[i].y_offset-cell[i].height;
		}
		
		object[cell[tap_obj].mark].x[current_set]=tap_obj_x+dx;
		object[cell[tap_obj].mark].y[current_set]=tap_obj_y+dy;
		if (overview_flag==TRUE) {
			calc_move(
				current_set,
				cell[tap_obj].mark,
				tap_obj_x2-object[cell[tap_obj].mark].x[current_set],
				tap_obj_y2-object[cell[tap_obj].mark].y[current_set],
				0,0,cnf.width-1,cnf.height-1,&rc);
		} else {
			calc_move(
				current_set,
				cell[tap_obj].mark,
				tap_obj_x2-object[cell[tap_obj].mark].x[current_set],
				tap_obj_y2-object[cell[tap_obj].mark].y[current_set],
				disp_x,disp_y,disp_x+winWidth-1,disp_y+winHeight-1,&rc);
		}
		tap_obj_x2=object[cell[tap_obj].mark].x[current_set];
		tap_obj_y2=object[cell[tap_obj].mark].y[current_set];
//		calc_all(current_set);
	}
	if (overview_flag==TRUE) {
		rc.left=ov_sx;
		rc.right=ov_sx+ov_xs;
		rc.top=ov_sy+cbh;
		rc.bottom=ov_sy+ov_ys+cbh+30;
		InvalidateRect(hWnd,&rc,FALSE);
	} else {
		rc.top+=cbh;
		rc.bottom+=cbh;
		InvalidateRect(hWnd,&rc,FALSE);
	}
}

void mouse_up(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	if (pesi_flag==TRUE) {
		int		f,i;
		f=object[cell[tap_obj].mark].fix;
		object[cell[tap_obj].mark].fix=0;
		i=5;
		do {
			f>>=1;
			object[cell[tap_obj].mark].fix+=f;
		} while (--i);
	}	
//	calc_all(current_set);
//	InvalidateRect(hWnd,NULL,FALSE);
}
/* =====================================================================
	wv{^ꂽ
===================================================================== */
void OnHelp(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	OnHelpAbout(hWnd); 
}

/* =====================================================================
	t@CEj[ - I
===================================================================== */
void OnFileExit(HWND hWnd) 
{
/*
	wsprintf(reg_file,TEXT("%s"),bmpfile[sort_result[sortkey][bmp_num]]);
	reg_sortkey=sortkey;
	reg_recursive = under_dir_flag==FALSE ? 0 : 1;
	set_reg();
*/
	abandon_all();
	SendMessage(hWnd, WM_CLOSE, 0, 0L);
}

/* =====================================================================
	wvEj[ - o[W̕\
===================================================================== */
void OnHelpAbout(HWND hWnd)
{
	DialogBox(ghInst, MAKEINTRESOURCE(IDD_ABOUT_DIALOG),
		hWnd, AboutDlgProc);
}


/* =====================================================================
    o[W̕\_CAO
===================================================================== */
BOOL CALLBACK AboutDlgProc(HWND hDlg, UINT uMessage,
						   WPARAM wParam, LPARAM lParam)
{
	switch (uMessage) {
	  case WM_INITDIALOG:			// _CAOE{bNX̏
		SetFocus(GetDlgItem(hDlg, IDOK));	// OK{^ɃtH[JXݒ
		return FALSE;				// tH[JXݒ肵FALSEԂ

	  case WM_COMMAND:				// R}h󂯎
		switch (wParam) {
		  case IDOK:				// [OK]{^ꂽ
		  case IDCANCEL:			// []Iꂽ
			EndDialog(hDlg, TRUE);	// ^CAOE{bNX
			return TRUE;
		}
		break;
	}
	return FALSE;	// bZ[WȂꍇFALSEԂ
}

/*
void put_property(HWND hWnd)
{
	DialogBox(ghInst, MAKEINTRESOURCE(IDD_PROPERTY_DIALOG),
		hWnd, PropertyDlgProc);
}

BOOL CALLBACK PropertyDlgProc(HWND hDlg, UINT uMessage,
						   WPARAM wParam, LPARAM lParam)
{
	TCHAR	str[MAX_PATH];
	int		i,j;
	HANDLE	hFile; 
	FILETIME	ctime,atime,wtime,lctime,lwtime;
	SYSTEMTIME	stime;

	switch (uMessage) {
	  case WM_INITDIALOG:			// _CAOE{bNX̏
		wsprintf(str,TEXT("\\%s"),bmpfile[sort_result[sortkey][bmp_num]]);
		j=0;
		for (i=0;;i++) {
			if (str[i]=='\0') break;
			if (str[i]=='\\') {
				j=i;
			}
		}
		str[j]='\0';
		SetDlgItemText (hDlg, IDC_FILENAME, str+j+1);
		SetDlgItemText (hDlg, IDC_LOCATION, str);

		hFile = CreateFile( bmpfile[sort_result[sortkey][bmp_num]], GENERIC_READ, FILE_SHARE_READ,0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 ) ;

		wsprintf(str,TEXT("%d x %d  (%d bit/pixel)"),bmp_width,bmp_height,bmp_pixel);
		SetDlgItemText (hDlg, IDC_PICSIZE    , str);

		wsprintf(str,TEXT("%d bytes"),GetFileSize(hFile,NULL));
		SetDlgItemText (hDlg, IDC_FILESIZE    , str);

		GetFileTime(hFile,&ctime,&atime,&wtime);
		FileTimeToLocalFileTime(&ctime,&lctime);
		FileTimeToSystemTime(&lctime,&stime);
		wsprintf(str,TEXT("%d/%d/%d  %02d:%02d:%02d"),stime.wYear,stime.wMonth,stime.wDay,stime.wHour,stime.wMinute,stime.wSecond);
		SetDlgItemText (hDlg, IDC_CREATED, str);

		GetFileTime(hFile,&ctime,&atime,&wtime);
		FileTimeToLocalFileTime(&wtime,&lwtime);
		FileTimeToSystemTime(&lwtime,&stime);
		wsprintf(str,TEXT("%d/%d/%d  %02d:%02d:%02d"),stime.wYear,stime.wMonth,stime.wDay,stime.wHour,stime.wMinute,stime.wSecond);
		SetDlgItemText (hDlg, IDC_MODIFIED, str);

		CloseHandle( hFile ) ;
		SetFocus(GetDlgItem(hDlg, IDOK));	// OK{^ɃtH[JXݒ
		return FALSE;				// tH[JXݒ肵FALSEԂ

	  case WM_COMMAND:				// R}h󂯎
		switch (wParam) {
		  case IDOK:				// [OK]{^ꂽ
		  case IDCANCEL:			// []Iꂽ
			EndDialog(hDlg, TRUE);	// ^CAOE{bNX
			return TRUE;
		}
		break;
	}
	return FALSE;	// bZ[WȂꍇFALSEԂ
}
*/
// TreeView

void set_tree(HWND ht,TCHAR *filepath,HTREEITEM hp)
{
	HTREEITEM	hCurrent;
	TV_INSERTSTRUCT tv;
	HANDLE	hFile; 
	WIN32_FIND_DATA data;
	TCHAR	fpath[MAX_PATH],fn2[MAX_PATH];

	wsprintf(fn2,TEXT("%s*"),filepath);
	hFile=FindFirstFile(fn2,&data);
	if (hFile == INVALID_HANDLE_VALUE) return;
	for (;;) {
		if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
		    tv.hInsertAfter = TVI_LAST;
		    tv.item.mask = TVIF_TEXT;
		    tv.hParent = hp;
		    tv.item.pszText = data.cFileName;
		    hCurrent = TreeView_InsertItem(ht, &tv);

			wsprintf(fpath,TEXT("%s%s\\"),filepath,data.cFileName);
			set_tree(ht,fpath,hCurrent);
		}
		if (FindNextFile(hFile,&data)==NULL) break;
	}
	FindClose(hFile);
}

void set_tree_list(HWND hl,TCHAR *filepath,BOOL flag)
{
	HANDLE	hFile; 
	WIN32_FIND_DATA data;
	TCHAR	fpath[MAX_PATH],fn2[MAX_PATH];
	
	wsprintf(fn2,TEXT("%s*"),filepath);
	hFile=FindFirstFile(fn2,&data);
	if (hFile == INVALID_HANDLE_VALUE) return;
	for (;;) {
		if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			if (under_dir_flag==TRUE) {
				wsprintf(fpath,TEXT("%s%s\\"),filepath,data.cFileName);
				set_tree_list(hl,fpath,flag);
			}
		} else {
			int	i,p;
			TCHAR	str[MAX_PATH];
			for (p=0;;p++)
				if (data.cFileName[p]=='\0') break;
			for (i=0;i<3;i++) {
				str[i]=data.cFileName[p-3+i];
				if ('A'<=str[i] && str[i]<='Z') str[i]+='a'-'A';
			}
			if (str[0]=='c' && str[1]=='n' && str[2]=='f') {
				ListBox_AddItemData(hl, data.cFileName);
				wsprintf(listbox_filename[listbox_num],TEXT("%s%s"),filepath,data.cFileName);
				listbox_num++;
				listbox_max++;
			}
		}
		if (FindNextFile(hFile,&data)==NULL) break;
	}
	FindClose(hFile);
}

void put_tree(HWND hWnd)
{
	DialogBox(ghInst, MAKEINTRESOURCE(pspc_flag==TRUE ? IDD_TREE_DIALOG : IDD_TREE_H_DIALOG),
		hWnd, TreeDlgProc);
}

BOOL CALLBACK TreeDlgProc(HWND hDlg, UINT uMessage,
						   WPARAM wParam, LPARAM lParam)
{
	HWND hTree;
	HTREEITEM	hTop;
	TV_INSERTSTRUCT tv;
	LPNMHDR	lpnm=(LPNMHDR)lParam;

	switch (uMessage) {
	  case WM_INITDIALOG:			// _CAOE{bNX̏
		hTree = GetDlgItem(hDlg, IDC_DIRTREE);

	    tv.hInsertAfter = TVI_LAST;
	    tv.item.mask = TVIF_TEXT;
	    tv.hParent = TVI_ROOT;
	    tv.item.pszText = TOP_TREE_STR;
	    hTop = TreeView_InsertItem(hTree, &tv);
		set_tree(hTree,TEXT("\\"),hTop); 
		TreeView_Expand(hTree,hTop,TVE_EXPAND);
 
//		SetFocus(GetDlgItem(hDlg, IDOK));	// OK{^ɃtH[JXݒ
		return FALSE;				// tH[JXݒ肵FALSEԂ

	  case WM_COMMAND:				// R}h󂯎
		switch (LOWORD(wParam)) { 
		  case IDCANCEL:			// []Iꂽ
			EndDialog(hDlg, TRUE);	// ^CAOE{bNX
			return TRUE;
		  case IDC_DIRFILE:
			if (HIWORD(wParam)==LBN_DBLCLK) {
				TCHAR	s[100],s2[MAX_PATH],fpath[MAX_PATH],fn[MAX_PATH];
				TV_ITEM		tv={0};
				HTREEITEM	hCurrent;
				int		num;

				num=ListBox_GetCurSel(GetDlgItem(hDlg,IDC_DIRFILE));
				ListBox_GetText(GetDlgItem(hDlg,IDC_DIRFILE),num,fn);
				fpath[0]='\0';
				hCurrent=TreeView_GetSelection(GetDlgItem(hDlg, IDC_DIRTREE));
				if (hCurrent!=NULL) {
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					for (;;) {
						tv.hItem=hCurrent;
						tv.mask |= TVIF_TEXT;
						tv.pszText = s;
						tv.cchTextMax =  100;
						TreeView_GetItem(GetDlgItem(hDlg, IDC_DIRTREE),&tv);
						if (wcscmp(s,TOP_TREE_STR)==0) break;
 						wsprintf(s2,TEXT("%s\\%s"),s,fpath);
						wsprintf(fpath,TEXT("%s"),s2);
						hCurrent=TreeView_GetParent(GetDlgItem(hDlg, IDC_DIRTREE),hCurrent);
					}
					abandon_all();
					if (load_cnf_file(fpath,fn)==FALSE) {
						MessageBox( NULL, TEXT("Load Error !"), TEXT("Error"), MB_OK ) ;
					}
					if (winWidth*cnf.height<winHeight*cnf.width) {
						ov_ys=winWidth*cnf.height/cnf.width;
						ov_sy=(winHeight-ov_ys)/2;
						ov_xs=winWidth;
						ov_sx=0;
					} else {
						ov_ys=winHeight;
						ov_sy=0;
						ov_xs=cnf.width*winHeight/cnf.height;
						ov_sx=(winWidth-ov_xs)/2;
					}
					current_set=0;
					calc_all(current_set);
					tap_obj=-1;
					unload_flag=FALSE;
					SetCursor(NULL);
				}
				EndDialog(hDlg, TRUE);	// ^CAOE{bNX
				return TRUE;  
			} 
			break;
		}
		break;
      case WM_NOTIFY:
		if (lpnm->code==TVN_SELCHANGED) {
			TCHAR	s[100],s2[MAX_PATH],fpath[MAX_PATH];
			TV_ITEM		tv={0};
			HTREEITEM	hCurrent;
			int		i;
//			hTree = GetDlgItem(hDlg, IDC_DIRTREE);
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			fpath[0]='\0';
			hCurrent=TreeView_GetSelection(lpnm->hwndFrom);
			for (;;) {
				tv.hItem=hCurrent;
				tv.mask |= TVIF_TEXT;
				tv.pszText = s;
				tv.cchTextMax =  100;
				TreeView_GetItem(lpnm->hwndFrom,&tv);
				if (wcscmp(s,TOP_TREE_STR)==0) break;
 				wsprintf(s2,TEXT("%s\\%s"),s,fpath);
				wsprintf(fpath,TEXT("%s"),s2);
				hCurrent=TreeView_GetParent(lpnm->hwndFrom,hCurrent);
			}
			i=ListBox_GetCount(GetDlgItem(hDlg,IDC_DIRFILE));
			SendDlgItemMessage( hDlg, IDC_DIRFILE, WM_SETREDRAW, FALSE, 0L );
			for (;;) {
				if (i==0) break;
				ListBox_DeleteString(GetDlgItem(hDlg,IDC_DIRFILE),0);
				i--;
			}
			listbox_num=0;
			listbox_max=0;
			set_tree_list(GetDlgItem(hDlg,IDC_DIRFILE),fpath,under_dir_flag);
			SendDlgItemMessage( hDlg, IDC_DIRFILE, WM_SETREDRAW, TRUE, 0L );
			SetCursor(NULL);
		}

        break;

		default:
			return DefWindowProc(hDlg, uMessage, wParam, lParam);
	}
	return FALSE;	// bZ[WȂꍇFALSEԂ
}

// 
// Registry
//

BOOL
get_reg( void )
{
/*
	HKEY	hk ;
	LONG	lret ;
	LPTSTR	name ;
	LPBYTE	lpData ;
	DWORD	dwType, cbData ;

	// WXgL[I[v 
	lret = RegOpenKeyEx( HKEY_CURRENT_USER, subkey, 0,
						 KEY_QUERY_VALUE, &hk ) ;
	if ( lret != ERROR_SUCCESS ) {
		return FALSE ;
	}
	// fBNg 
	name = TEXT("PATH") ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) reg_dir ;
	cbData = sizeof reg_dir ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	// t@C 
	name = TEXT("FILE") ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) reg_file ;
	cbData = sizeof reg_file ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	// \[g 
	name = TEXT("SORTKEY") ;
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &reg_sortkey ;
	cbData = sizeof reg_sortkey ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	// Recursive 
	name =  TEXT("RECURSIVE");
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &reg_recursive ;
	cbData = sizeof reg_sortkey ;
	lret = RegQueryValueEx( hk, name, NULL, &dwType, lpData, &cbData ) ;
	// WXgN[Y
	RegCloseKey( hk ) ;
*/
	return TRUE ;
}

BOOL
set_reg( void )
{
/*
	HKEY	hk ;
	LONG	lret ;
	LPTSTR	name ;
	LPBYTE	lpData ;
	DWORD	ret, dwType, cbData ;

	// WXgL[쐬
	lret = RegCreateKeyEx( HKEY_CURRENT_USER, subkey, 0, TEXT(""), 0,
						   NULL, NULL, &hk, &ret ) ;
	if ( lret != ERROR_SUCCESS ) {
		return FALSE ;
	}
	// fBNg 
	name = TEXT("PATH"); ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) reg_dir ;
	cbData = (_tcslen(reg_dir) + 1) * sizeof (*reg_dir) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	// t@C
	name = TEXT("FILE") ;
	dwType = REG_SZ ;
	lpData = (LPBYTE) reg_file ;
	cbData = (_tcslen(reg_file) + 1) * sizeof (*reg_file) ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	// \[g
	name =  TEXT("SORTKEY");
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &reg_sortkey ;
	cbData = sizeof reg_sortkey ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	// Recursive
	name =  TEXT("RECURSIVE");
	dwType = REG_DWORD ;
	lpData = (LPBYTE) &reg_recursive ;
	cbData = sizeof reg_recursive ;
	lret = RegSetValueEx( hk, name, 0, dwType, lpData, cbData ) ;
	// WXgN[Y
	RegCloseKey( hk ) ;
*/
	return TRUE ;
}

