#ifndef	UNICODE
#define	UNICODE
#endif	/* UNICODE */
#ifndef	_UNICODE
#define	_UNICODE
#endif	/* _UNICODE */
#define	STRICT
#include <windows.h>
#include <commctrl.h>
#include	<commdlg.h>
#include <wingdi.h>
#include "resource.h" 
#include <Winbase.h>
#include "jzpaint.h"

//TCHAR	Message[256];
extern OBJ		object[MAX_OBJ];

BOOL	load_pal(TCHAR *,TCHAR *);
BOOL	load_cell(TCHAR *,TCHAR *);
HANDLE	kiss_open(TCHAR *,TCHAR *);
void load_cell_data(int,int,int);
void make_bg(int); 

int		pal_max;
int		cell_max;
int		set_max;

int		bg_num=4;
int		gray_background;
TCHAR	path_str[MAX_PATH];

BMI bmi ;
BYTE				BmpLine[ PIC_WIDTH_MAX*3 ] ;
BITMAPFILEHEADER	BmpFH ;
BITMAPINFOHEADER	BmpIH ;

BOOL load_cnf_file(TCHAR *path,TCHAR *cnf_fn)
{
	HANDLE	hFile;
	DWORD	readsize ;
	TCHAR	fn[MAX_PATH];
	int		num;
	int		i,j;

	wsprintf(path_str,TEXT("%s"),path);
	wsprintf(fn,TEXT("\\%s%s"),path,cnf_fn);

	for (j=0;j<MAX_OBJ;j++)
		for (i=0;i<MAX_SET;i++) {
			object[j].x[i]=0;
			object[j].y[i]=0;
			object[j].org_x[i]=0;
			object[j].org_y[i]=0;
		}

	hFile = CreateFile( fn, GENERIC_READ, FILE_SHARE_READ,
				0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 ) ;
	if ( hFile == INVALID_HANDLE_VALUE ) {
		wsprintf(Message,TEXT("Cnf File Open error (%s)"),fn) ;
		MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
		return FALSE;
	}

	pal_max=0;
	cell_max=0;
	set_max=-1;

	for (i=0;i<MAX_CELL;i++)
		cell[i].data=NULL;
	for (i=0;i<MAX_PAL_FILE;i++)
		pal[i].data=NULL;

	for (i=0;i<MAX_OBJ;i++){
		object[i].fix=0;
		object[i].ini_fix=0;
	}

	for (;;) {
		TCHAR	str[1024];
		BOOL	eof_flag=FALSE;
		BYTE	c;
		int		i;
		for (i=0;;i++) {
			ReadFile( hFile, &c, 1, &readsize, NULL );
			if (readsize==0) {
				eof_flag=TRUE;
				break;
			}
			if (c==0x0d) {
				ReadFile( hFile, &c, 1, &readsize, NULL );
				str[i]='\0';
				break;
			}
			str[i]=c; 
		}
		if (eof_flag==TRUE) break;
		for (i=0;;i++) {
			if (str[i]=='\0') break;
			if (str[i]==';') {
				str[i]='\0';
				i--;
				for (;;i--) {
					if (str[i]!=' ' || str[i]!='\t') break;
					str[i]=='\0';
				}
				break;
			}
		}
//		MessageBox( NULL, str, TEXT("Error"), MB_OK ) ; 
		if (str[0]==';') continue;
		if (str[0]=='(') {
			int j;
			j=0;
			for (i=1;;i++) {
				if (str[i]==',')	break;
				if (str[i]<'0' || '9'<str[i]) continue;
				j=j*10+str[i]-'0';
			}
			cnf.width=j;
			j=0;
			for (;;i++) {
				if (str[i]==')') break;
				if (str[i]<'0' || '9'<str[i]) continue;
				j=j*10+str[i]-'0';
			}
			cnf.height=j;
		}
		if (str[0]=='%') {
			if (load_pal(path,&str[1])==FALSE) {
				return FALSE;
			}
		}
		if (str[0]=='#') { 
			if (load_cell(path,&str[1])==FALSE) {
				return FALSE;
			}
		}
		if (str[0]=='$') {
			set_max++; 
			cnf.pal[set_max]=str[1]-'0';   
			num=0;
			str[0]=' ';
			str[1]=' ';
		}
		if (str[0]==' ') {
			int i,k;
			for (i=1;;i++) { 
				if (str[i]=='\0') break;
				if (str[i]=='*') {
					num++;
					i++;
				}
				if (str[i]=='\0') break;
				if ('0'<=str[i] && str[i]<='9') {
					k=0;
					for (;;i++) {
						if (str[i]==',') break;
						k=k*10+str[i]-'0'; 
					};
					object[num].x[set_max]=k;
					object[num].org_x[set_max]=k;
					i++;
					k=0;
					for (;;i++) {
						if (str[i]<'0' || '9'<str[i]) break;
						k=k*10+str[i]-'0';
					};
					object[num].y[set_max]=k;
					object[num].org_y[set_max]=k;
					num++;
				}
				if (str[i]=='\0') break;
			}
		}
	} 
	set_max++;

	if (bitspixel==2) {
		int r,g,b,c;
		c=pal[0].data[0][0];
		r=c&0xff;
		g=(c>>8)&0xff;
		b=(c>>16)&0xff;
		gray_background=(r*3+g*6+b*1)/(256*10/4);
		make_bg(c);
	}
	
	CloseHandle( hFile ) ;
	return TRUE;
}

BOOL load_pal(TCHAR *path,TCHAR *fn)
{
	HANDLE	hFile;
	BYTE	buf[32];
	COL		c;
	DWORD	readsize;
	int		i,j;

	hFile=kiss_open(path,fn);
	if ( hFile == INVALID_HANDLE_VALUE ) {
		wsprintf(Message,TEXT("Pal File Open error (%s)"),fn) ;
		MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
		return FALSE;
	}
	
	ReadFile( hFile, buf, 32, &readsize, NULL );

	pal[pal_max].bpp=buf[ 5];
	pal[pal_max].num=buf[ 9]*256+buf[ 8];
	pal[pal_max].max=buf[11]*256+buf[10];

	if (buf[0]!='K' || buf[1]!='i' || buf[2]!='S' || buf[3]!='S') {
		pal[pal_max].bpp=12;
		pal[pal_max].num=16;
		pal[pal_max].max=10;
		CloseHandle( hFile ) ;
		hFile=kiss_open(path,fn);
	}
/*
	pal[pal_max].data=(COL **)malloc(sizeof(COL *)*pal[pal_max].max);
	for (j=0;j<pal[pal_max].max;j++) {
		pal[pal_max].data[j]=(COL *)malloc(sizeof(COL)*pal[pal_max].num);
		for (i=0;i<pal[pal_max].num;i++) {
			ReadFile( hFile, &c,sizeof(c), &readsize, NULL );
			if (pal[pal_max].bpp==12) {
				c.r|=c.r<<4;
				c.g|=c.g<<4;
				c.b|=c.b<<4;
			}
			pal[pal_max].data[j][i].r=c.r;
			pal[pal_max].data[j][i].g=c.g;
			pal[pal_max].data[j][i].b=c.b;
		}
	}
*/

	pal[pal_max].data=(int **)malloc(sizeof(int *)*pal[pal_max].max);
	if (pal[pal_max].data==NULL) {
		MessageBox( NULL, TEXT("Pal Malloc Error 1"), TEXT("Error"), MB_OK ) ;
		abandon_all();
		return FALSE;
	}
	for (j=0;j<pal[pal_max].max;j++) 
		pal[pal_max].data[j]=NULL;
	for (j=0;j<pal[pal_max].max;j++) {
		pal[pal_max].data[j]=(int *)malloc(sizeof(int)*pal[pal_max].num);
		if (pal[pal_max].data[j]==NULL) {
			MessageBox( NULL, TEXT("Pall Malloc Error 2"), TEXT("Error"), MB_OK ) ;
			abandon_all();
			return FALSE;
		}
		for (i=0;i<pal[pal_max].num;i++) {
			if (pal[pal_max].bpp==24) {
				ReadFile( hFile, &c,sizeof(c), &readsize, NULL );
			} else {
				BYTE buf[2];
				ReadFile( hFile, buf,2, &readsize, NULL );
				c.r=buf[0]&0xf0;
				c.b=(buf[0]&0x0f)<<4;
				c.g=(buf[1]&0x0f)<<4;
			}
			pal[pal_max].data[j][i]=((c.b)*256+c.g)*256+c.r; 
		}
	}

	pal_max++;
	CloseHandle( hFile ) ;
	return TRUE;
}

BOOL load_cell(TCHAR *path,TCHAR *str)
{
	HANDLE	hFile;
	BYTE	buf[32];
	DWORD	readsize;
	int		i,j,n;
	TCHAR	fn[MAX_PATH],*p;

	for (i=0;;i++) {
		if ('0'<=str[i] && str[i]<='9') break;
	}
	n=0;
	for (;;i++) {
		if (!('0'<=str[i] && str[i]<='9')) break;
		n=n*10+str[i]-'0';
	}
	cell[cell_max].mark=n;
	
	if (str[i]=='.') {
		i++;
		n=0;
		for (;;i++) {
			if (!('0'<=str[i] && str[i]<='9')) break;
			n=n*10+str[i]-'0';
		}
		if (object[cell[cell_max].mark].fix<n) {
			object[cell[cell_max].mark].fix=n;
			object[cell[cell_max].mark].ini_fix=n;
		}
	}

	for (;;i++) {
		if (str[i]!=' ' && str[i]!='\t') break;
	}
	p=&str[i];
	j=0;
	for (;;i++,j++) {
		if (!(str[i]=='.' || str[i]=='_' || ('0'<=str[i] && str[i]<='9') || ('A'<=str[i] && str[i]<='Z') || ('a'<=str[i] && str[i]<='z'))) break;
		fn[j]=str[i];
	}
	fn[j]='\0';
	
	cell[cell_max].pal=0;
	for (i=0;;i++) {
		if (str[i]=='\0') break;
		if (str[i]=='*')
			cell[cell_max].pal=str[i+1]-'0';
	} 
	
	for (i=0;i<MAX_SET;i++)
		cell[cell_max].set[i]=TRUE;
	for (i=0;;i++) {
		if (str[i]=='\0') break;
		if (str[i]==':') {
			for (j=0;j<MAX_SET;j++)
				cell[cell_max].set[j]=FALSE;
			for (j=i+1;;j++) { 
				if (str[j]=='\0' || str[j]=='*') break;
				if ('0'<=str[j] && str[j]<='9') 
					cell[cell_max].set[str[j]-'0']=TRUE;
			}
		} 
	}
	wsprintf(cell[cell_max].name,TEXT("%s"),fn);
	hFile=kiss_open(path,fn);
	if ( hFile == INVALID_HANDLE_VALUE ) {
		wsprintf(Message,TEXT("Cell File Open error (%s)\n(%s)"),fn,p) ;
		MessageBox( NULL, Message, TEXT("Error"), MB_OK ) ;
		return FALSE;
	}
	
	ReadFile( hFile, buf, 4, &readsize, NULL );
	if (buf[0]!='K' || buf[1]!='i' || buf[2]!='S' || buf[3]!='S') {
		cell[cell_max].bpp		=4;
		cell[cell_max].width	=buf[1]*256+buf[0];
		cell[cell_max].height	=buf[3]*256+buf[2];
		cell[cell_max].x_offset	=0;
		cell[cell_max].y_offset	=0;
		cell[cell_max].data_offset=4;
	} else {
		ReadFile( hFile, buf+4, 32-4, &readsize, NULL );
		cell[cell_max].bpp		=buf[ 5];
		cell[cell_max].width	=buf[ 9]*256+buf[ 8];
		cell[cell_max].height	=buf[11]*256+buf[10];
		cell[cell_max].x_offset	=buf[13]*256+buf[12];
		cell[cell_max].y_offset	=buf[15]*256+buf[14];
		cell[cell_max].data_offset=32;
	}
	if (bitspixel==2) {
		cell[cell_max].data=(BYTE *)malloc(cell[cell_max].width*cell[cell_max].height);
	} else {
		cell[cell_max].data=(BYTE *)malloc(cell[cell_max].width*cell[cell_max].height);
	}
	if (cell[cell_max].data==NULL) {
		MessageBox( NULL, TEXT("Cell Malloc Error"), TEXT("Error"), MB_OK ) ;
		abandon_all();
		return FALSE;
	}
	CloseHandle( hFile ) ;
	load_cell_data(cell_max,0,-1);
	cell_max++;
	return TRUE;
}

void load_cell_data(int n,int s,int old_s)
{
	HANDLE	hFile;
	BYTE	buf[MAX_WIDTH],buf2[MAX_WIDTH],*b;
	long	*ebuf_this,*ebuf_next,*ebuf_swap;
	DWORD	readsize;
	int		i,j;

	if (s==old_s) return;
//	if (cell[n].set[s]==FALSE) return;

	if (old_s>=0) {
		int i;
		BOOL flag=FALSE;
		for (i=0;i<pal[cell[n].pal].num;i++) 
			if (pal[cell[n].pal].data[s][i]!=pal[cell[n].pal].data[old_s][i])
				flag==TRUE;
		if (flag==FALSE) return;
	}
	hFile=kiss_open(path_str,cell[n].name);
	ReadFile( hFile, buf, cell[n].data_offset, &readsize, NULL );
	if (bitspixel==2) {
		BYTE	*d=cell[n].data;
		ebuf_this=(long*)malloc(sizeof(long)*(cell[n].width+2));
		ebuf_next=(long*)malloc(sizeof(long)*(cell[n].width+2));
		for (i=0;i<cell[n].width+2;i++)
			ebuf_this[i]=Random()%(1024*2)-1024;

		for (j=0;j<cell[n].height;j++) {
			for (i=0;i<cell[n].width+2;i++)
				ebuf_next[i]=0;
			if (cell[n].bpp==4) {
				BYTE	*d=cell[cell_max].data;
				ReadFile( hFile, buf2, (cell[n].width+1)/2, &readsize, NULL );
				b=buf;
				for (i=0;i<cell[n].width;i++) {
					if (i%2==0)	*b++=buf2[i/2]>>4;
					else		*b++=buf2[i/2]&0x0f;
				}
			} else {
				ReadFile( hFile, buf, cell[n].width, &readsize, NULL );
			}
			for (i=0;i<cell[n].width;i++) {
				int c,cc,r,g,b;
				BYTE	cmap[4]={0,0x40,0xc0,0xff};
				long ec,err;
				cc=pal[cell[n].pal].data[s][buf[i]]; 
				r=cc&0xff;
				g=(cc>>8)&0xff;
				b=(cc>>16)&0xff;
				c=(r*3+g*6+b*1)/10;
				if (c>255) c=255;
				ec=(ebuf_this[i+1])/1024+c;
				if (ec<0) ec=0;
				if (ec>255) ec=255;
				if (0x00<=ec && ec<0x20)  *d=0;
				if (0x20<=ec && ec<0x80)  *d=1;
				if (0x80<=ec && ec<0xe0)  *d=2;
				if (0xe0<=ec && ec<=0xff) *d=3;
				err=(ec-cmap[*d])*1024;
				ebuf_this[i+2]+=err*7/16;
				ebuf_next[i  ]+=err*3/16;
				ebuf_next[i+1]+=err*5/16;
				ebuf_next[i+2]+=err  /16;
				if (buf[i]==0)	*d=0;
				else		*d|=0x80;
				d++;
			}
			ebuf_swap=ebuf_this;
			ebuf_this=ebuf_next;
			ebuf_next=ebuf_this;
		}
		free(ebuf_this);
		free(ebuf_next);
	} else {
		if (cell[cell_max].bpp==4) {
			BYTE	*d=cell[n].data;
			for (j=0;j<cell[n].height;j++) {
				ReadFile( hFile, buf, (cell[n].width+1)/2, &readsize, NULL );
				for (i=0;i<cell[n].width;i++) {
					if (i%2==0) {
						*d++=buf[i/2]>>4;
					} else {
						*d++=buf[i/2]&0x0f;
					}
				}
			}
		} else {
			ReadFile( hFile, cell[n].data, cell[n].width*cell[n].height, &readsize, NULL );
		}
	}
	CloseHandle( hFile ) ;
}

void make_bg(int col)
{
	BYTE	d;
	long	*ebuf_this,*ebuf_next,*ebuf_swap;
	int		i,j;
	int c,r,g,b;
	static BYTE	cmap[4]={0,0x50,0xc0,0xff};

	r=col&0xff; 
	g=(col>>8)&0xff;
	b=(col>>16)&0xff;
	c=(r*3+g*6+b*1)/10;
	if (c>255) c=255;

	ebuf_this=(long*)malloc(sizeof(long)*(MAX_WIDTH+2));
	ebuf_next=(long*)malloc(sizeof(long)*(MAX_WIDTH+2));
	for (i=0;i<MAX_WIDTH+2;i++)
		ebuf_this[i]=(Random()%(1024*2))-1024;

	for (j=0;j<MAX_HEIGHT;j++) {
		for (i=0;i<MAX_WIDTH+2;i++)
			ebuf_next[i]=0; 
		for (i=0;i<MAX_WIDTH;i++) {
			long ec,err;
			ec=(ebuf_this[i+1])/1024+c;
			if (ec<0) ec=0;
			if (ec>255) ec=255;
			if (0x00<=ec && ec<0x20)  d=0;
			if (0x20<=ec && ec<0x80)  d=1;
			if (0x80<=ec && ec<0xe0)  d=2;
			if (0xe0<=ec && ec<=0xff) d=3;
			set_pixel(bgBuf,i,j,d);
			err=(ec-cmap[d])*1024;
			ebuf_this[i+2]+=err*7/16;
			ebuf_next[i  ]+=err*3/16;
			ebuf_next[i+1]+=err*5/16;
			ebuf_next[i+2]+=err  /16;
		}
		ebuf_swap=ebuf_this;
		ebuf_this=ebuf_next;
		ebuf_next=ebuf_this;
	}
	free(ebuf_this);
	free(ebuf_next);
}

void change_set(int current,int old)
{
/*
	int n;

	if (bitspixel!=2) return;
	if (pal[0].data[current][0]!=pal[0].data[old][0]) {
		make_bg(pal[0].data[current][0]);
	}
	for (n=0;n<cell_max;n++) {
		load_cell_data(n,current,old);
	}
*/
}


HANDLE kiss_open(TCHAR *path,TCHAR *open_fn)
{ 
	TCHAR	fn[MAX_PATH];
	HANDLE	hFile;
	int		i;

	for (i=0;;i++) 
		if (open_fn[i]=='\0') break;
	for (i--;;i--) {
		if (open_fn[i]==' ' || open_fn[i]=='\t')
			open_fn[i]='\0';
		else break;
	}

	wsprintf(fn,TEXT("%s\\%s"),path,open_fn);
	hFile = CreateFile( fn, GENERIC_READ, FILE_SHARE_READ,
				0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 ) ;
	if ( hFile != INVALID_HANDLE_VALUE ) return hFile;

	for (i=0;;i++) {
		if (open_fn[i]=='\0') break;
		if ('a'<=open_fn[i] && open_fn[i]<='z')
			open_fn[i]+=-'a'+'A';
	}
	wsprintf(fn,TEXT("%s\\%s"),path,open_fn);
	hFile = CreateFile( fn, GENERIC_READ, FILE_SHARE_READ,
				0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 ) ;
	if ( hFile != INVALID_HANDLE_VALUE ) return hFile;

	for (i=0;;i++) {
		if (open_fn[i]=='\0') break;
		if ('A'<=open_fn[i] && open_fn[i]<='Z')
			open_fn[i]+=-'A'+'a';
	}
	wsprintf(fn,TEXT("%s\\%s"),path,open_fn);
	hFile = CreateFile( fn, GENERIC_READ, FILE_SHARE_READ,
				0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 ) ;
	if ( hFile != INVALID_HANDLE_VALUE ) return hFile;

	MessageBox( NULL, fn, TEXT("Error"), MB_OK ) ;
	return FALSE;
}

void abandon_all()
{
	int	i,j;

	for (j=0;j<pal_max;j++) {
		if (pal[j].data!=NULL) {
			for (i=0;i<pal[j].max;i++)
				if (pal[j].data[i]!=NULL)
					free(pal[j].data[i]);
			free(pal[j].data);
		}
	}

	for (j=0;j<cell_max;j++) 
		if (cell[j].data!=NULL)
			free(cell[j].data);
}