/* dyokyun.c:  Dancin'yokyun DA for Palm
 *
 * 2000 Tomohiro Ueno
 * http://user1.allnet.ne.jp/~ueno/
 *
 * based on Fortune_DA by Desk Accessaries for PalmOS/pilot-tech ML members
 *  (http://member.nifty.ne.jp/yamakado/da/index.htm)
 */

#include <Common.h>
#include <System/SysAll.h>
#include <System/SysEvtMgr.h>
#include <UI/UIAll.h>
#include <System/SoundMgr.h> 
#include "dyokyun.h"

#define	dYknDACreatorID	'dYkn'
#define	dYknDAPrefsID	0

#define	dYknDAPrefsVersion	0x0000

#define TimePeriod 10

int	seq2;

// preference
typedef struct _prefs {
    SWord lastX, lastY;
} _prefs;
    
// global variable
typedef struct _global {
    _prefs prefs;
    SWord fromX, fromY;
    Boolean moving;
    Int	  gseq;
    Int   mseq;
} _global;

void DAMain();
static Boolean DrawTimes(Boolean flg, Boolean flg2, _global *g);

/* This code must be here. (first of code section)*/
/* ̃R[h͂ɂȂႾ߁B(R[ḧ̎n)*/
void start()
{
    DAMain();
}

/*========================================================================*/

/* Followings are real implementatiom */
/* ȉۂ̎ */
static void *GetObjectPtr(int objectID)
{
    FormPtr form;
    Int     index;
    void    *ptr;

    form  = FrmGetActiveForm();
    index = FrmGetObjectIndex(form, objectID);
    ptr   = FrmGetObjectPtr(form, index);
    return (ptr);
}

/* Initialize Preference */
/* Preference ̏ */
static void InitPrefs(_global *g)
{
    MemSet(&g->prefs, sizeof(_prefs), 0L);
    g->prefs.lastX = dyokyunInitX;
    g->prefs.lastY = dyokyunInitY;
}

/* Load Preference */
/* vt@Xǂݍ */
static void LoadPrefs(_global *g)
{
    Int version;
    Word prefSize;

    version = PrefGetAppPreferences(
	dYknDACreatorID,
	dYknDAPrefsID,
	&g->prefs,
	&prefSize,
	true                    // persistent
    );
    if (version == noPreferenceFound) {
	/* No preference found, create it with default value */
	/* Preference Ȃ̂ŁAftH[gݒ */
	InitPrefs(g);
    } else {
	switch (version) {
	default:
	    ;
       }
    }
}

/* Save Preference */
/* vt@Xۑ */
static void SavePrefs(_global *g)
{
    PrefSetAppPreferences(
	dYknDACreatorID,
	dYknDAPrefsID,
	dYknDAPrefsVersion,
	&g->prefs,
	sizeof(g->prefs),
	true                    // persistent
    );
}

/* Initialize global variables */
/* O[oϐ */
static _global *InitGlobals()
{
    _global *g;
    g = MemPtrNew(sizeof(_global));
    return (g);
}

/* Get Parent application name ... but not used in this DA */
/* ẽAvP[V擾 ...  DA ł͖gp */
Err GetCurAppName(CharPtr name)
{
    Err error;
    UInt cardNo;
    LocalID dbID;

    error = SysCurAppDatabase(&cardNo, &dbID);
    if(!error)
	error = DmDatabaseInfo(cardNo, dbID, name, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    return (error);
}

/* Tapped inside of this DA's form ? */
/*  DA ̃tH[̓Ń^bvꂽ? */
static Boolean IsInside(RectanglePtr r, SWord x, SWord y)
{
  return (0 <= x && x <= r->extent.x && 0 <= y && y <= r->extent.y);
}

/* Tapped outside of this DA's form ? */
/*  DA ̃tH[̊OŃ^bvꂽ? */
static Boolean IsOutside(RectanglePtr r, SWord x, SWord y)
{
  return (!IsInside(r, x, y));
}

/* Draw frame with EX-OR mode */
/* t[ EX-OR [hŕ` */
static void ExorFrame(Word topLeftX, Word topLeftY, _global *g)
{
    RectangleType r;

    r.topLeft.x = topLeftX + 2;
    r.topLeft.y = topLeftY + 2;
    r.extent.x  = dyokyunXsize  - 4;
    r.extent.y  = dyokyunYsize - 4;
    WinInvertRectangleFrame(boldRoundFrame, &r);
}

/* Event Handler */
/* Cxgnh[ */
static Boolean DAHandleEvent(EventPtr event, _global *g)
{
    Boolean done = false;
    Boolean handled = false;
    FormPtr form;
    SWord moveX, moveY;
    Word ch;
    Boolean drawflag;
    Boolean drawmovecheck;
		
    drawflag = false;
    drawmovecheck = false;
    switch (event->eType) {
    case nilEvent:
	drawflag = true;
	done = false;
        handled= true;
        break;
    case appStopEvent:
        drawflag = false;
	/* Send appStopEvent to original application */
	/* appStopEvent AƂ̃AvP[Vɑ */
	EvtAddEventToQueue(event);
	done = true;
	handled = true;
	break;
    case keyDownEvent:
        drawflag = false;
	ch = event->data.keyDown.chr;
	if (ChrIsHardKey(ch)) {
	    /* maybe 'HotSync!' button pressed ? */
	    /* HotSync! {^ꂽ? */
	    EvtAddEventToQueue(event);
	    done = true;
	    handled = true;
	}
	break;
    /* Following implements 'Draggable' feature */
    /* ȉ́AhbKu@\̎ */
    case penDownEvent:
        drawflag = false;
	form = FrmGetActiveForm();
	if (IsInside(&form->window.windowBounds,
		event->screenX, event->screenY)) {
	    /* Start Drag */
	    /* hbOJn */
	    g->fromX  = event->screenX;
	    g->fromY  = event->screenY;
	    g->moving = true;
	    FrmEraseForm(form);
	    /* Draw only frame as dragging */
	    /* hbÓAg\ */
	    ExorFrame(0, 0, g);
	    handled = true;
	} else if (IsOutside(&form->window.windowBounds,
		event->screenX, event->screenY)) {
	    /* Pen tapped on Outside of form -- quit */
	    /* tH[̊OŃ^bvꂽ -- I */
	    done = true;
	    handled = true;
	}
	break;
    case penMoveEvent:
        drawflag = false;
	if (g->moving) {
	    form = FrmGetActiveForm();
	    moveX = event->screenX - g->fromX;
	    moveY = event->screenY - g->fromY;

	    /* Erase previous frame */
	    /* Oɕ`悵g */
	    ExorFrame(0, 0, g);

	    /* Compute new form position */
	    /* VtH[ʒuvZ */
	    form->window.windowBounds.topLeft.x += moveX;
	    form->window.windowBounds.topLeft.y += moveY;
	    if (form->window.windowBounds.topLeft.x < FrameWidth) {
		form->window.windowBounds.topLeft.x = FrameWidth;
	    }
	    if (form->window.windowBounds.topLeft.y < FrameWidth) {
		form->window.windowBounds.topLeft.y = FrameWidth;
	    }
	    if (form->window.windowBounds.topLeft.x + 
		    form->window.windowBounds.extent.x +
		    FrameWidth >= form->window.displayWidth) {
		form->window.windowBounds.topLeft.x =
		    form->window.displayWidth - 
		    form->window.windowBounds.extent.x - FrameWidth;
	    }
	    if (form->window.windowBounds.topLeft.y + 
		  form->window.windowBounds.extent.y +
		  FrameWidth >= form->window.displayHeight) {
		form->window.windowBounds.topLeft.y =
		    form->window.displayHeight - 
		    form->window.windowBounds.extent.y - FrameWidth;
	    }
	    /* Draw new frame */
	    /* Vg\ */
	    ExorFrame(0, 0, g);
	    handled = true;
	}
	break;
    case penUpEvent:
        drawflag = false;
	form = FrmGetActiveForm();
	if (g->moving) {
	    /* Erase last frame */
	    /* ȑO̘g */
	    ExorFrame(0, 0, g);
	    /* Save last position into preference */
	    /* vt@XɁAŌ̈ʒuL^ */
	    g->prefs.lastX = form->window.windowBounds.topLeft.x;
	    g->prefs.lastY = form->window.windowBounds.topLeft.y;
	    g->moving = false;
	    FrmDrawForm(form);
	    handled = true;
	}
	break;
    default:
	break;
    }
    if (!handled) {
	FrmHandleEvent(FrmGetActiveForm(), event);
    }
    DrawTimes(drawflag, g->moving, g);
    return (done);
}

/* Event Loop */
/* Cxg[v */
static void EventLoop(_global *g)
{
    EventType event;
    Boolean done = false;
    Word error;
    do {
//	EvtGetEvent(&event, evtWaitForever);
        EvtGetEvent(&event, TimePeriod);
	if (SysHandleEvent(&event))
	    continue;
	if (MenuHandleEvent(NULL, &event, &error))
	    continue;
	done = DAHandleEvent(&event, g);
    } while (!done);
}

void drawBitmap(Int x, Int y, Int id)
{
  VoidHand h;
  VoidPtr p;

  h = DmGet1Resource('Tbmp', id);
  if(h != NULL){
    p = MemHandleLock(h);
    WinDrawBitmap((BitmapPtr)p, x, y);
    MemHandleUnlock(h);
    DmReleaseResource(h);
  }
}

/* time write */
/* ` */
static Boolean DrawTimes(Boolean flg, Boolean flg2, _global *g) {

	char *xloc="42,41,41,45,48,47,47,49,45,45,55,55,54,48,39,20,05,01,01,01,01,10,10,09,09,05,03,03,07,19,22,23,25,32,39,44";
	char *yloc="16,16,16,07,07,14,15,16,16,15,14,14,13,13,12,11,11,09,03,03,03,07,08,13,20,20,19,16,16,15,15,15,16,15,15,07";
	char *mu="34579395594954393454939897959439345793955949543945699992345999912349543933212939555696944959543299339999999493929931999999919293343909191594394999996549567999999999999999999999999999999";
//		  01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789
//		  0         1         2         3         4         5         6         7         8         9         0         1         2         3         4         5         6 
	SndCommandType s; /* TEhR}h̕ϐ̐錾 */

	int	x,y,m;

	PointType ErTopLeft;
	PointType ErExtent;
	RectangleType ErRect;
	ErTopLeft.x = 0;
	ErTopLeft.y = 30;
	ErExtent.x = 37;
	ErExtent.y = 20;
	ErRect.topLeft = ErTopLeft;
	ErRect.extent = ErExtent;
	
	if(flg == false) {
		return false;
	}
	if(flg2 == true) {
		return false;
	}

	if (g->gseq%2==0) {
		m=mu[g->mseq]-'0';
		if (m!=9) {
			s.cmd = 3;/* R}h */
			s.param1=220;	
			if (m==0)	s.param1=494;
			if (m==1)	s.param1=554;
			if (m==2)	s.param1=622;
			if (m==3)	s.param1=659;
			if (m==4)	s.param1=740;
			if (m==5)	s.param1=831;
			if (m==6)	s.param1=880;
			if (m==7)	s.param1=988;
			if (m==8)	s.param1=1109;
			s.param2 = 1000; /*  (ms) */
			s.param3 = 15; /* 傫 (dB) R */
			SndDoCmd(0, &s, true);
		}
		g->mseq++;
		if (g->mseq==160) g->mseq=0;
	}	

	x=(xloc[g->gseq*3]-'0')*10+(xloc[g->gseq*3+1]-'0');
	y=(yloc[g->gseq*3]-'0')*10+(yloc[g->gseq*3+1]-'0');
	drawBitmap(18+x,y+15, 2100+g->gseq);
	g->gseq++;
	if (g->gseq==36) g->gseq=4;
/*
	{
		char tmp[16];
		char str1[32], str2[32];
		FontID oldfont;
		oldfont=FntSetFont (stdFont);
//		WinEraseRectangle(&ErRect,0);
		StrIToA( tmp, g->seq2);
		WinDrawChars( tmp,StrLen(tmp), 80, 50);
		FntSetFont(oldfont);
	}
*/
	return true;
}

/* main function body */
/* C֐{ */
void DAMain()
{
    _global *g;
    FormPtr form;
    DWord feature = 0;

    /* Check duplicate invocation of Fortune DA */
    /* (Fortune DA) DA ̓dNoB*/
    if (FtrGet(dYknDACreatorID, 0, &feature) == 0) {
	/* Already Fortune DA is invoked -- duplicate invocation */
	/* ł Fortune DA NĂ -- dN */
	return;
    } else {
	/* To avoid duplicate invocation, set feature */
	/* dN邽߂ɃtB[`[o^ */
	FtrSet(dYknDACreatorID, 0, feature);
    }

    /* Allocate && initialize global variables */
    /* O[oϐ̈̊蓖ĂƂ̏ */
    g = InitGlobals();
    if (g == NULL) {
	/* Fail to allocate global variables area */
	/* O[oϐ̈̊蓖ĂɎs */
	return;
    }
    /* ̈BfalseɂĂȂƏNɁA*/
    /* ړg\Ă܂ */
    g->moving = false;
    g->gseq=0;
    g->mseq=0;

    /* Load Preferences from last invoked */
    /* ȑONꂽƂ Preference [h */
    LoadPrefs(g);

    /* Activate Main Form */
    /* CtH[N */
    form  = FrmInitForm(dyokyunForm);

    /* Restore last position */
    /* ŌɋNꂽʒu𕜌 */
    form->window.windowBounds.topLeft.x = g->prefs.lastX;
    form->window.windowBounds.topLeft.y = g->prefs.lastY;
    FrmSetActiveForm(form);
    FrmDrawForm(form);

    /* Show time */
    /* Ԃ̕\ */
    DrawTimes(true, false,g);

    /* goto event handler */
    /* Cxgnh[ɐn */
    EventLoop(g);

    /* finish up application */
    /* AvP[V̏I */
    SavePrefs(g);
    FrmEraseForm(form);
    FrmDeleteForm(form);

    /* Release feature */
    /* tB[`[ */
    if (FtrGet(dYknDACreatorID, 0, &feature) == 0) {
	FtrUnregister(dYknDACreatorID, 0);
    }

    /* Release Global area */
    /* O[oϐ̈ */
    MemPtrFree(g);
}
